package wzorceproj.polecenie.impreza;

public class MakroPolecenie implements Polecenie {
   Polecenie[] polecenia;
 
   public MakroPolecenie(Polecenie[] polecenia) {
      this.polecenia = polecenia;
   }
 
   public void wykonaj() {
      for (int i = 0; i < polecenia.length; i++) {
         polecenia[i].wykonaj();
      }
   }
 
   /**
    * UWAGA: Aby mechanizm wycofywania działał prawidłowo,
    * te polecenia muszą być wykonywane w odwrotnej kolejności
    */
   public void wycofaj() {
      for (int i = polecenia.length -1; i >= 0; i--) {
         polecenia[i].wycofaj();
      }
   }
}

