package wzorceproj.obserwator.stacjameteopoczatki;

public class IndeksCiepłaPanel implements Obserwator, PanelInformacyjny {
	float indeksCiepła = 0.0f;

	public IndeksCiepłaPanel(DanePogodowe danePogodowe) {
		danePogodowe.zarejestrujObserwator(this);
	}

	public void aktualizacja(float temperatura, float wilgotność, float ciśnienie) {
		float t = temperatura;
		float rh = wilgotność;
		
		// przeliczenie stopni Celsjusza na stopnie Fahrenheita wymagane przez wzór na indeks ciepła
		t = t*1.8f + 32.0f;

		indeksCiepła = (float)
			(
			(16.923 + (0.185212 * t)) + 
			(5.37941 * rh) - 
			(0.100254 * t * rh) + 
			(0.00941695 * (t * t)) + 
			(0.00728898 * (rh * rh)) + 
			(0.000345372 * (t * t * rh)) - 
			(0.000814971 * (t * rh * rh)) +
			(0.0000102102 * (t * t * rh * rh)) - 
			(0.000038646 * (t * t * t)) + 
			(0.0000291583 * (rh * rh * rh)) +
			(0.00000142721 * (t * t * t * rh)) + 
			(0.000000197483 * (t * rh * rh * rh)) - 
			(0.0000000218429 * (t * t * t * rh * rh)) +
			(0.000000000843296 * (t * t * rh * rh * rh)) -
			(0.0000000000481975 * (t * t * t * rh * rh * rh)));


		// Przeliczenie wyliczonej temp. odczuwalnej z powrotem na stopnie Celsjusza
		indeksCiepła = (indeksCiepła - 32f) / 1.8f;

		wyświetl();
	}

	public void wyświetl() {
		System.out.println("Indeks ciepła wynosi: " + indeksCiepła);
	}
}
