package wzorceproj.laczenie.fabryka;

public class SymulatorKaczek {
   public static void main(String[] args) {
      SymulatorKaczek symulator = new SymulatorKaczek();
      AbstrakcyjnaFabrykaKaczek fabrykaKaczek = new FabrykaKaczekZLicznikiem();
 
      symulator.uruchom(fabrykaKaczek);
   }
 
   void uruchom(AbstrakcyjnaFabrykaKaczek fabrykaKaczek) {
      Kwacząca krzyżówkaKaczka = fabrykaKaczek.utwórzKrzyżówkaKaczka();
      Kwacząca płaskonosKaczka = fabrykaKaczek.utwórzPłaskonosKaczka();
      Kwacząca wabikKaczka = fabrykaKaczek.utwórzWabikKaczka();
      Kwacząca gumowaKaczka = fabrykaKaczek.utwórzGumowaKaczka();
      Kwacząca gęśKaczka = new GęśAdapter(new Gęś());
 
      System.out.println("\nSymulator kaczek: z fabryką abstrakcyjną");
 
      uruchom(krzyżówkaKaczka);
      uruchom(płaskonosKaczka);
      uruchom(wabikKaczka);
      uruchom(gumowaKaczka);
      uruchom(gęśKaczka);
 
      System.out.println("Kaczki zakwakały w sumie " + 
                         KwakLicznik.pobierzLiczbęKwaknięć() + 
                         " razy");
   }
 
   void uruchom(Kwacząca kaczka) {
      kaczka.kwacz();
   }
}
