package wzorceproj.fasada.kinodomowe;

public class OdtwarzaczMultimediów {
	String opis;
	int bieżącyFragment;
	Wzmacniacz wzmacniacz;
	String film;
	
	public OdtwarzaczMultimediów(String description, Wzmacniacz amplifier) {
		this.opis = description;
		this.wzmacniacz = amplifier;
	}
 
	public void włącz() {
		System.out.println(opis + ": włączony");
	}
 
	public void wyłącz() {
		System.out.println(opis + ": wyłączony");
	}
 
	public void odtwarzaj(String movie) {
		this.film = movie;
		bieżącyFragment = 0;
		System.out.println(opis + ": odtwarzanie filmu \"" + movie + "\"");
	}

	public void odtwarzaj(int fragment) {
		if (film == null) {
			System.out.println(opis + ": nie można odtworzyć fragmentu " + fragment + ", gdyż nie wybrano filmu");
		} else {
			bieżącyFragment = fragment;
			System.out.println(opis + ": odtwarzanie fragmentu " + bieżącyFragment + " filmu \"" + film + "\"");
		}
	}

	public void zatrzymaj() {
		bieżącyFragment = 0;
		System.out.println(opis + ": zatrzymano \"" + film + "\"");
	}
 
	public void wstrzymaj() {
		System.out.println(opis + ": wstrzymano odtwarzanie \"" + film + "\"");
	}

	public void ustawDźwiękDwukanałowy() {
		System.out.println(opis + ": wybrano dźwięk dwukanałowy");
	}
 
	public void ustawDźwiękPrzestrzenny() {
		System.out.println(opis + ": wybrano dźwięk przestrzenny");
	}
 
	public String toString() {
		return opis;
	}
}
