package wzorceproj.fasada.kinodomowe;

public class OdtarzaczCD {
	String opis;
	int bieżącaŚcieżka;
	Wzmacniacz wzmacniacz;
	String tytuł;
	
	public OdtarzaczCD(String opis, Wzmacniacz wzmacniacz) {
		this.opis = opis;
		this.wzmacniacz = wzmacniacz;
	}
 
	public void włącz() {
		System.out.println(opis + ": włączony");
	}
 
	public void wyłącz() {
		System.out.println(opis + ": wyłączony");
	}

	public void wysuń() {
		tytuł = null;
		System.out.println(opis + ": wysuwanie płyty");
	}
 
	public void odtwarzaj(String tytuł) {
		this.tytuł = tytuł;
		bieżącaŚcieżka = 0;
		System.out.println(opis + ": odtwarza utwór \"" + tytuł + "\".");
	}

	public void odtwarzaj(int ścieżka) {
		if (tytuł == null) {
			System.out.println(opis + ": nie może odtwarzać ścieżki " + bieżącaŚcieżka + 
					", nie włożono płyty.");
		} else {
			bieżącaŚcieżka = ścieżka;
			System.out.println(opis + ": odtwarza ścieżkę " + bieżącaŚcieżka);
		}
	}

	public void zatrzymaj() {
		bieżącaŚcieżka = 0;
		System.out.println(opis + ": zatrzymany");
	}
 
	public void wstrzymaj() {
		System.out.println(opis + ": wstrzymał odtwarzanie utworu \"" + tytuł + "\"");
	}
 
	public String toString() {
		return opis;
	}
}
