package wzorceproj.laczenie.obserwator;

public class SymulatorKaczek {
   public static void main(String[] args) {
      SymulatorKaczek symulator = new SymulatorKaczek();
      AbstrakcyjnaFabrykaKaczek fabrykaKaczek = new FabrykaKaczekZLicznikiem();
 
      symulator.uruchom(fabrykaKaczek);
   }
  
   void uruchom(AbstrakcyjnaFabrykaKaczek fabrykaKaczek) {
  
      Kwacząca płaskonosKaczka = fabrykaKaczek.utwórzPłaskonosKaczka();
      Kwacząca wabikKaczka = fabrykaKaczek.utwórzWabikKaczka();
      Kwacząca gumowaKaczka = fabrykaKaczek.utwórzGumowaKaczka();
      Kwacząca gęśKaczka = new GęśAdapter(new Gęś());
 
      Stado stadoKaczek = new Stado();
 
      stadoKaczek.dodaj(płaskonosKaczka);
      stadoKaczek.dodaj(wabikKaczka);
      stadoKaczek.dodaj(gumowaKaczka);
      stadoKaczek.dodaj(gęśKaczka);
 
      Stado stadoKaczekKrzyżówek = new Stado();
 
      Kwacząca krzyżówkaJeden = fabrykaKaczek.utwórzKrzyżówkaKaczka();
      Kwacząca krzyżówkaDwa = fabrykaKaczek.utwórzKrzyżówkaKaczka();
      Kwacząca krzyżówkaTrzy = fabrykaKaczek.utwórzKrzyżówkaKaczka();
      Kwacząca krzyżówkaCztery = fabrykaKaczek.utwórzKrzyżówkaKaczka();

      stadoKaczekKrzyżówek.dodaj(krzyżówkaJeden);
      stadoKaczekKrzyżówek.dodaj(krzyżówkaDwa);
      stadoKaczekKrzyżówek.dodaj(krzyżówkaTrzy);
      stadoKaczekKrzyżówek.dodaj(krzyżówkaCztery);

      stadoKaczek.dodaj(stadoKaczekKrzyżówek);

      System.out.println("\nStado kaczek: ze wzorcem Obserwator");

      Kwakolog kwakolog = new Kwakolog();
      stadoKaczek.zarejestrujObserwator(kwakolog);

      uruchom(stadoKaczek);

      System.out.println("\nKaczki zakwakały w sumie " + 
                         KwakLicznik.pobierzLiczbęKwaknięć() + 
                         " razy");
   }
 
   void uruchom(Kwacząca kaczka) {
      kaczka.kwacz();
   }
}
