package wzorceproj.laczenie.obserwator;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

public class Obserwowany implements KwakObserwowany {
   List<Obserwator> obserwatory = new ArrayList<Obserwator>();
   KwakObserwowany kaczka;
 
   public Obserwowany(KwakObserwowany kaczka) {
      this.kaczka = kaczka;
   }
  
   public void zarejestrujObserwator(Obserwator obserwator) {
      obserwatory.add(obserwator);
   }
  
   public void powiadomObserwatory() {
      Iterator<Obserwator> iterator = obserwatory.iterator();
      while (iterator.hasNext()) {
         Obserwator obserwator = iterator.next();
         obserwator.aktualizuj(kaczka);
      }
   }
 
   public Iterator<Obserwator> pobierzObserwatorów() {
      return obserwatory.iterator();
   }
}
