package wzorceproj.iterator.laczeniebiznesowobiadmania;

import java.util.Iterator;
import java.util.Calendar;

public class WymienneObiadowoMenuIterator implements Iterator<PozycjaMenu> {
	PozycjaMenu[] elementy;
	int pozycja;

	public WymienneObiadowoMenuIterator(PozycjaMenu[] elementy) {
		this.elementy = elementy;
		pozycja = Calendar.DAY_OF_WEEK % 2;
	}
	public PozycjaMenu next() {
		PozycjaMenu pozycjaMenu = elementy[pozycja];
		pozycja = pozycja + 2;
		return pozycjaMenu;
	}
	public boolean hasNext() {
		if (pozycja >= elementy.length || elementy[pozycja] == null) {
			return false;
		} else {
			return true;
		}
	}
	/* 
	 * Nie potrzebne zaczynając od wersji Java 8
	 * 
	 * (non-Javadoc)
	 * @see java.util.Iterator#remove()
	 * 
	public void remove() {
		throw new UnsupportedOperationException(
			"Iterator wymiennego menu baru Obiadowo nie obsługuje metody remove()");
	}
	*/
}
