package wzorceproj.stan.gumomatstan;

public class AutomatSprzedający {
 
   Stan stanBrakGum;
   Stan stanNieMaMonety;
   Stan stanJestMoneta;
   Stan stanGumaSprzedana;
 
   Stan stan = stanBrakGum;
   int liczba = 0;
 
   public AutomatSprzedający(int liczbaGum) {
      stanBrakGum = new StateBrakGum(this);
      stanNieMaMonety = new StanNieMaMonety(this);
      stanJestMoneta = new StanJestMoneta(this);
      stanGumaSprzedana = new StanGumaSprzedana(this);

      this.liczba = liczbaGum;
      if (liczbaGum > 0) {
         stan = stanNieMaMonety;
      } else {
         stan = stanBrakGum;
      }
   }
 
   public void włóżMonetę() {
      stan.włóżMonetę();
   }
 
   public void zwróćMonetę() {
      stan.zwróćMonetę();
   }
 
   public void przekręćGałkę() {
      stan.przekręćGałkę();
      stan.wydaj();
   }
 
   void zwolnijGumę() {
      System.out.println("Wypada guma");
      if (liczba > 0) {
         liczba = liczba - 1;
      }
   }
 
   int pobierzLiczba() {
      return liczba;
   }
 
   void napełnij(int liczba) {
      this.liczba += liczba;
      System.out.println("Automat ponownie napełniono; liczba dostępnych gum: " + this.liczba);
      stan.napełnij();
   }

   void ustawStan(Stan stan) {
      this.stan = stan;
   }
   public Stan pobierzStan() {
      return stan;
   }

   public Stan pobierzStanBrakGum() {
      return stanBrakGum;
   }

   public Stan pobierzStanNieMaMonety() {
      return stanNieMaMonety;
   }

   public Stan pobierzStanJestMoneta() {
      return stanJestMoneta;
   }

   public Stan pobierzStanGumaSprzedana() {
      return stanGumaSprzedana;
   }
 
   public String toString() {
      StringBuffer result = new StringBuffer();
      result.append("\nAutomaty Sprzedające SA");
      result.append("\nWolnostojący automat do sprzedaży gum Gumomat Model #2004 Java\n");
      result.append("Zapas gum: " + liczba );
      result.append("\nBieżący stan automatu: ");
      result.append("Automat znajduje się w stanie " + stan + "\n");
      return result.toString();
   }
}
