package wzorceproj.obserwator.stacjameteo;

import java.util.*;

public class DanePogodowe implements Podmiot {
   private List<Obserwator> obserwatory;
   private float temperatura;
   private float wilgotność;
   private float ciśnienie;

   public DanePogodowe() {
      obserwatory = new ArrayList<Obserwator>();
   }

   public void zarejestrujObserwator(Obserwator o) {
      obserwatory.add(o);
   }

   public void usuńObserwator(Obserwator o) {
      obserwatory.remove(o);
   }
   
   public void powiadomObserwatory() {
      for (Obserwator obserwator : obserwatory) {
         obserwator.aktualizacja(temperatura, wilgotność, ciśnienie);
      }
   }

   public void zmienionoOdczyty() {
      powiadomObserwatory();
   }

   public void ustawOdczyty(float temperatura, float wilgotność, float ciśnienie) {
      this.temperatura = temperatura;
      this.wilgotność = wilgotność;
      this.ciśnienie = ciśnienie;
      zmienionoOdczyty();
   }   

   // W tym miejscu można wstawić inne metody obiektu DanePogodowe
	public float pobierzTemperatura() {
		return temperatura;
	}
	
	public float pobierzWilgotność() {
		return wilgotność;
	}
	
	public float pobierzCiśnienie() {
		return ciśnienie;
	}

}

