package wzorceproj.kompozyt.menuiterator;

import java.util.Iterator;

public class PozycjaMenu extends MenuSkładnik {
 
	String nazwa;
	String opis;
	boolean wegetariańska;
	double cena;
    
	public PozycjaMenu(String nazwa, 
	                String opis, 
	                boolean wegetariańska, 
	                double cena) 
	{ 
		this.nazwa = nazwa;
		this.opis = opis;
		this.wegetariańska = wegetariańska;
		this.cena = cena;
	}
  
	public String pobierzNazwa() {
		return nazwa;
	}
  
	public String pobierzOpis() {
		return opis;
	}
  
	public double pobierzCena() {
		return cena;
	}
  
	public boolean czyJestWegetariańska() {
		return wegetariańska;
	}

	public Iterator<MenuSkładnik> utwórzIterator() {
		return new PustyIterator();
	}
 
	public void drukuj() {
		System.out.print("  " + pobierzNazwa());
		if (czyJestWegetariańska()) {
			System.out.print("(v)");
		}
		System.out.println(", " + pobierzCena());
		System.out.println("     -- " + pobierzOpis());
	}

}

