package wzorceproj.kompozyt.menuiterator;

import java.util.*;
  
public class IteratorZłożony implements Iterator<MenuSkładnik> {
	Stack<Iterator<MenuSkładnik>> stos = new Stack<Iterator<MenuSkładnik>>();
   
	public IteratorZłożony(Iterator<MenuSkładnik> iterator) {
		stos.push(iterator);
	}
   
	public MenuSkładnik next() {
		if (hasNext()) {
			Iterator<MenuSkładnik> iterator = stos.peek();
			MenuSkładnik składnik = iterator.next();
			stos.push(składnik.utwórzIterator());
			return składnik;
		} else {
			return null;
		}
	}
  
	public boolean hasNext() {
		if (stos.empty()) {
			return false;
		} else {
			Iterator<MenuSkładnik> iterator = stos.peek();
			if (!iterator.hasNext()) {
				stos.pop();
				return hasNext();
			} else {
				return true;
			}
		}
	}
	
	/*
	 * Zaczynając od wersji Java 8 tam metoda nie jest już potrzebna
	 * 
	 * (non-Javadoc)
	 * @see java.util.Iterator#remove()
	 *
	public void remove() {
		throw new UnsupportedOperationException();
	}
	*/
}


