package wzorceproj.prototyp;

public abstract class Potwór implements Cloneable {
	boolean czyJeDzieci = true;
	boolean czyMaSkrzydła = false;
	int liczbaGłów = 1;
	boolean czyZionieOgniem = false;
	String nazwa;
	public Potwór(String nazwa) {
		this.nazwa = nazwa;
	}
	public void plujJadem() { } // domyślnie nic nie robi
	public void ustawNazwę(String nazwa) {
		this.nazwa = nazwa;
	}
	
	public abstract Potwór kopiuj() throws CloneNotSupportedException;
	
	public String toString() {
		StringBuffer s = new StringBuffer("Jestem potworem, którego nazywają " + this.nazwa + " i mam " + 
				this.liczbaGłów + " " + (this.liczbaGłów == 1 ? "głowę" : "głowy") + ".");
		if (this.czyZionieOgniem) { s.append("Potrafię zionąć ogniem. "); }
		if (this.czyJeDzieci) { s.append("Pożeram dzieci. "); }
		if (this.czyMaSkrzydła) { s.append("Mam skrzydła. "); }
		return s.toString();
	}
}