package wzorceproj.polecenie.swing;
   
import java.awt.*;
import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

   
public class PrzykładObserwatoraSwing {
   JFrame frame;
   
   public static void main(String[] args) {
      PrzykładObserwatoraSwing example = new PrzykładObserwatoraSwing();
      example.go();
   }
   
   public void go() {
      frame = new JFrame();

      JButton button = new JButton("Czy powinienem to zrobić?");
      
      // Bez stosowania wyrażeń lambda
      //button.addActionListener(new AnielskiObNasłuchujący());
      //button.addActionListener(new DiabelskiObNasłuchujący());
      
      // Z użyciem wyrażeń lambda
      button.addActionListener(event -> 
         System.out.println("Nie rób, mógłbyś tego żałować!"));
      button.addActionListener(event ->
         System.out.println("Pewnie, zrób to!"));

      frame.getContentPane().add(BorderLayout.CENTER, button);

      // Określamy parametry ramki
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.getContentPane().add(BorderLayout.CENTER, button);
      frame.setSize(300,300);
      frame.setVisible(true);
   }
   
   /*
    * Jeśli chcesz zastosować wyrażenia lambda, to usuń te dwie klasy wewnętrzne
    * albo zostaw je w komentarzu.
    * 
   class AnielskiObNasłuchujący implements ActionListener {
      public void actionPerformed(ActionEvent event) {
         System.out.println("Nie rób, mógłbyś tego żałować!");
      }
   }

   class DiabelskiObNasłuchujący implements ActionListener {
      public void actionPerformed(ActionEvent event) {
         System.out.println("Pewnie, zrób to!");
      }
   }
   */
}
