package wzorceproj.polaczone.djview;
  
public class BeatKontroler implements KontrolerInterfejs {
    BeatModelInterfejs model;
    DJWidok widok;
    
    public BeatKontroler(BeatModelInterfejs model) {
        this.model = model;
        widok = new DJWidok(this, model);
        widok.utwórzWidok();
        widok.utwórzElementySterujące();
        widok.dezaktywujStopMenuItem();
        widok.aktywujStartMenuItem();
        model.inicjuj();
    }
  
    public void start() {
        model.start();
        widok.dezaktywujStartMenuItem();
        widok.aktywujStopMenuItem();
    }
  
    public void stop() {
        model.stop();
        widok.dezaktywujStopMenuItem();
        widok.aktywujStartMenuItem();
    }
     
    public void zwiększBPM() {
        int bpm = model.pobierzBPM();
        model.ustawBPM(bpm + 1);
    }
     
    public void zmniejszBPM() {
        int bpm = model.pobierzBPM();
        model.ustawBPM(bpm - 1);
      }
  
     public void ustawBPM(int bpm) {
        model.ustawBPM(bpm);
    }
}
