package wzorceproj.obserwator.stacjameteoobserwator;

import java.util.Observable;
import java.util.Observer;
	
public class WarunkiBieżącePanel implements Observer, PanelInformacyjny {
	Observable obserwowalny;
	private float temperatura;
	private float wilgotność;
	
	public WarunkiBieżącePanel(Observable obserwowalny) {
		this.obserwowalny = obserwowalny;
		obserwowalny.addObserver(this);
	}
	
	public void update(Observable obs, Object arg) {
		if (obs instanceof DanePogodowe) {
			DanePogodowe danePogodowe = (DanePogodowe)obs;
			this.temperatura = danePogodowe.pobierzTemperature();
			this.wilgotność = danePogodowe.pobierzWilgotność();
			wyświetl();
		}
	}
	
	public void wyświetl() {
		System.out.println("Warunki bieżące: " + temperatura 
			+ " stopni C oraz " + wilgotność + "% wigotność");
	}
}
