package wzorceproj.iterator.laczeniebiznesow;

import java.util.*;

public class TestMenu {
   public static void main(String args[]) {
      NaleśnikarniaMenu naleśnikarniaMenu = new NaleśnikarniaMenu();
      ObiadowoMenu obiadowoMenu = new ObiadowoMenu();
 
      Kelnerka kelnerka = new Kelnerka(naleśnikarniaMenu, obiadowoMenu);
      
      // Drukowanie przy użyciu iteratorów
      kelnerka.drukujMenu();
      
      drukujMenu();
   }
   
   /*
    * Bez korzystania z możliwości Kelnerki musielibyśmy używać następującego kodu:
    */
   public static void drukujMenu() {
      NaleśnikarniaMenu naleśnikarniaMenu = new NaleśnikarniaMenu();
      ObiadowoMenu obiadowoMenu = new ObiadowoMenu();

      List<PozycjaMenu> pozycjeŚniadaniowe = naleśnikarniaMenu.pobierzPozycjeMenu();
      PozycjaMenu[] pozycjePoryLunchu = obiadowoMenu.pobierzPozycjeMenu();
      
      // Wyświetlamy jako Iterable
      drukujMenu(pozycjeŚniadaniowe);
      drukujMenu(Arrays.asList(pozycjePoryLunchu));
      
      // Wyświetlamy przy użyciu metody forEach
      System.out.println("=== forEach ===");
      pozycjeŚniadaniowe.forEach(item -> System.out.println(item));
      Arrays.asList(pozycjePoryLunchu).forEach(item -> System.out.println(item));
      System.out.println("=== forEach ===");
      
      // Wyświetlamy używając nowych, rozszerzonych pętli for
      System.out.println("USING ENHANCED FOR");
      for (PozycjaMenu pozycjaMenu : pozycjeŚniadaniowe) {
         System.out.print(pozycjaMenu.pobierzNazwa());
         System.out.println("\t\t" + pozycjaMenu.pobierzCena());
         System.out.println("\t" + pozycjaMenu.pobierzOpis());
      }
      for (PozycjaMenu pozycjaMenu : pozycjePoryLunchu) {
         System.out.print(pozycjaMenu.pobierzNazwa());
         System.out.println("\t\t" + pozycjaMenu.pobierzCena());
         System.out.println("\t" + pozycjaMenu.pobierzOpis());
      }
 
      // Wyświetlamy używając konkretnych implementacji
      System.out.println("Z UŻYCIEM PĘTLI FOR");
      for (int i = 0; i < pozycjeŚniadaniowe.size(); i++) {
         PozycjaMenu pozycjaMenu = (PozycjaMenu)pozycjeŚniadaniowe.get(i);
         System.out.print(pozycjaMenu.pobierzNazwa());
         System.out.println("\t\t" + pozycjaMenu.pobierzCena());
         System.out.println("\t" + pozycjaMenu.pobierzOpis());
      }
      for (int i = 0; i < pozycjePoryLunchu.length; i++) {
         PozycjaMenu pozycjaMenu = pozycjePoryLunchu[i];
         System.out.print(pozycjaMenu.pobierzNazwa());
         System.out.println("\t\t" + pozycjaMenu.pobierzCena());
         System.out.println("\t" + pozycjaMenu.pobierzOpis());
      }
   }
   
   public static void drukujMenu(Iterable<PozycjaMenu> a) {
      for (PozycjaMenu menuItem : a) {
         System.out.print(menuItem.pobierzNazwa());
         System.out.println("\t\t" + menuItem.pobierzCena());
         System.out.println("\t" + menuItem.pobierzOpis());
      }
   }
}
