package wzorceproj.budowniczy.wakacje;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public abstract class BudowniczyPlanu {
	String nazwa;
	List<Zakwaterowanie> zakwaterowania = new ArrayList<Zakwaterowanie>();
	List<String> atrakcje = new ArrayList<String>();
	
	public abstract BudowniczyPlanu dodajZakwaterowanie();
	public abstract BudowniczyPlanu dodajZakwaterowanie(String name);
	public abstract BudowniczyPlanu dodajZakwaterowanie(String name, int year, int month, int day, int nights, int location);
	public abstract BudowniczyPlanu dodajAtrakcję(String event);
	
	public Urlop pobierzPlanUrlopu() {
		Urlop urlop = new Urlop();
		urlop.ustawNazwę(nazwa);
		urlop.ustawZakwaterowania(zakwaterowania);
		urlop.ustawAtrakcje(atrakcje);
		return urlop;
	}
}