package wzorceproj.kompozyt.menu;

import java.util.Iterator;
import java.util.ArrayList;
import java.util.List;

public class Menu extends MenuSkładnik {
   List<MenuSkładnik> menuSkładniki = new ArrayList<MenuSkładnik>();
   String nazwa;
   String opis;
  
   public Menu(String nazwa, String opis) {
      this.nazwa = nazwa;
      this.opis = opis;
   }
 
   public void dodaj(MenuSkładnik menuSkładnik) {
      menuSkładniki.add(menuSkładnik);
   }
 
   public void usuń(MenuSkładnik menuSkładnik) {
      menuSkładniki.remove(menuSkładnik);
   }
 
   public MenuSkładnik pobierzPotomek(int i) {
      return (MenuSkładnik)menuSkładniki.get(i);
   }
 
   public String pobierzNazwa() {
      return nazwa;
   }
 
   public String pobierzOpis() {
      return opis;
   }
 
   public void drukuj() {
      System.out.print("\n" + pobierzNazwa());
      System.out.println(", " + pobierzOpis());
      System.out.println("---------------------");
  
      for (MenuSkładnik menuSkładnik : menuSkładniki) {
         menuSkładnik.drukuj();
      }      

      /*
      Iterator<MenuSkładnik> iterator = menuSkładniki.iterator();
      while (iterator.hasNext()) {
         MenuSkładnik menuSkładnik = 
            (MenuSkładnik)iterator.next();
         menuSkładnik.drukuj();
      }
      */
   }
}
