import java.util.Map;

final class VehicleCache {
  
    private static final Map<String, Vehicle> map = Map.of("szybkie-auto", new FastCar(), "wolne-auto", new SlowCar());

    private VehicleCache(){}
    static Vehicle getVehicle(String type){
        Vehicle vehicle = map.get(type);
        if(vehicle == null) throw new IllegalArgumentException("niedozwolone:" + type);
        return (Vehicle) vehicle.clone();
    }
}
