import java.util.Arrays;

class MarkerMain {
    public static void main(String[] args) {
        System.out.println("Wzorzec Znacznik, identyfikacja czujników");
        var sensors = Arrays
                .asList(new BreaksSensor(), new EngineSensor()
                        , new ConsumptionSensor());
        sensors.forEach(sensor -> {
            if(sensor.getClass().isAnnotationPresent(CertifiedAnnotation.class)){
                System.out.println("Czujnik z adnotacją Marker:" + sensor);
            } else {
                switch (sensor){
                    case CertifiedSensor cs -> System.out.println("Czujnik z interfejsem znacznika: " + cs);
                    case Sensor s -> System.out.println("Czujnik bez znacznika: "+ s);
                }
            }
        });

    }

}
