class FastEngine implements Engine{
    private final String type;
    private boolean started;

    public FastEngine(String type) {
        this.type = type;
    }

    @Override
    public void start() {
        System.out.println("FastEngine, uruchomiony");
        started = true;
    }

    @Override
    public boolean isStarted() {
        return started;
    }

    @Override
    public void run() {
        if(started){
            System.out.println("FastEngine, działa");
        } else {
            throw new IllegalStateException("FastEngine, nie uruchomiony");
        }
    }

    @Override
    public String type() {
        return type;
    }
}
