class VehicleSystemCheckVisitor implements  CheckVisitor{

    @Override
    public void visit(EngineCheck engineCheck) {
        System.out.println("EngineCheck, gotowy");
        visitBySwitch(engineCheck);
    }

    @Override
    public void visit(SuspensionCheck suspensionCheck) {
        System.out.println("SuspensionCheck, gotowy");
        visitBySwitch(suspensionCheck);
    }

    @Override
    public void visit(BreaksCheck breaksCheck) {
        System.out.println("BreakCheck, gotowy");
        visitBySwitch(breaksCheck);
    }

    @Override
    public void visit(VehicleCheck vehicleCheck) {
        System.out.println("VehicleCheck, gotowy");
        visitBySwitch(vehicleCheck);
    }


    private void visitBySwitch(SystemCheck systemCheck){
        switch (systemCheck){
            case EngineCheck e -> System.out.println("EngineCheck, gotowy, ponowna kontrola, " + e);
            case SuspensionCheck s -> System.out.println("SuspensionCheck, gotowy, ponowna kontrola, " + s);
            case BreaksCheck b -> System.out.println("BreakCheck, gotowy, ponowna kontrola, " + b);
            case VehicleCheck v -> System.out.println("VehicleCheck, gotowy, ponowna kontrola, " + v);
            case null -> System.out.println("VehicleSystemCheckVisitor, brak możliwości");
            default -> System.out.println("VehicleSystemCheckVisitor, nie zaimplementowano");
        }
    }
}
