import java.util.HashMap;
import java.util.Map;

class VehicleGarage {

    private static final Map<String, Vehicle> vehicleByType = new HashMap<>();
    static {
        vehicleByType.put("miejski", new VehicleType("auto-miejskie"));
        vehicleByType.put("sportowy", new VehicleType("auto-sportowe"));
    }

    private VehicleGarage() {
    }

    static Vehicle borrow(String type){
        Vehicle v = vehicleByType.get(type);
        if(v == null){
            v = new VehicleType(type);
            vehicleByType.put(type, v);
        }
        // Zwraca jedynie kopię, nie obiekt
        System.out.println("VehicleGarage, typ pożyczonego samochodu: " + type);
        return v;
    }
}
