### Tworzenie i otwieranie zapisów Java Flight Recorder

Projekt zawiera kilka zapisów ***.jfr***. W nazwach plików został umieszczony numer rysunku stworzonego przy użyciu danego zapisu. Do stworzenia tych rysunków użyłem program **Java Mission Control v 8.2**. Pliki *.jfr można otwierać przy użyciu aplikacji **Java Mission Control**, którą można pobrać ze stron WWW wymienionych poniżej.

Odnośniki do pobierania:
- https://github.com/openjdk/jmc
- https://adoptium.net/jmc/

```bash 
# Uruchamianie JavaFlightRecorder na potrzeby wzroców
# Rejestrowano z użyciem Java 17
$ java -XX:StartFlightRecording=filename=<PATTERN_NAME_MAIN>.jfr,dumponexit=true,settings=profile <MAIN_CLASS>
```

## Rozdział 7. - Popularne antywzorce
```bash
#  Fenomen odzyskiwania pamięci
$ javac --release 17 --enable-preview -g -cp out/Rozdzial07/odzyskiwanie_pamieci -sourcepath java -d out/Rozdzial07/odzyskiwanie_pamieci ./Rozdzial07/odzyskiwanie_pamieci/*.java
$ java --enable-preview -cp out/Rozdzial07/odzyskiwanie_pamieci GarbageMain


#  Fenomen zajętej metody
$ javac --release 17 --enable-preview -g -cp out/Rozdzial07/zajeta_metoda -sourcepath java -d out/Rozdzial07/zajeta_metoda ./Rozdzial07/zajeta_metoda/*.java
$ java --enable-preview -cp out/Rozdzial07/zajeta_metoda BusyMethodMain
```
