import java.util.HashMap;
import java.util.Map;

final class VehicleProvider {

    private Vehicle truck;
    private Vehicle car;

    VehicleProvider() {
    }

    Vehicle getVehicleByType(String type){
        
        switch(type){
            case "auto":
                if(car == null){
                    System.out.println("leniwie utworzono auto");
                    car = new LazyVehicle(type);
                
                }
                return car;
            case "ciężarówka":
                if(truck == null){
                    System.out.println("leniwie utworzono ciężarówkę");
                    truck = new LazyVehicle(type);
                }
                return truck;
            default:
                throw new IllegalArgumentException("nie zaimplementowano");    
        }

    }

    void printStatus(){
        System.out.println("stan, ciężarówka:" + truck);
        System.out.println("stan, auto:" + car);
    }

}
