# ZDA-044 Zmiana na architekturę sterowaną zdarzeniami

## Status
Zatwierdzony, 04.10.2023
Zastępuje [ARD-031 Używanie funkcji serverless](https://odnośnik-do-zastępowanego-ADR)

## Kontekst
System Polyglot Media jest obecnie systemem rozproszonym, składającym się głównie z funkcji serverless. Przejście z architektury monolitycznej na rozproszoną architekturę serverless miało na celu rozwiązanie problemów z responsywnością systemu w trakcie działania i długim czasem oczekiwania na przygotowanie i wdrożenie w środowisku produkcyjnym zarówno nowych funkcjonalności, jak i poprawek.

Architektura serverless nie rozwiązała problemów z responsywnością lub łatwością utrzymania w wymaganym stopniu, ze względu na bardzo wysoki poziom powiązań pomiędzy poszczególnymi funkcjami.

Należy znaleźć rozwiązanie problemów związanych z szybkością reakcji i czasem wprowadzenia produktu na rynek.

## Decyzja
Wykorzystamy architekturę sterowaną zdarzeniami, bazując na jej wysokiej skalowalności i responsywności. Mikrousługi i rozwiązanie oparte na usługach nie spełniają najważniejszego kryterium — responsywności.

## Konsekwencje

### *Pozytywy*
* Zyskujemy ogólnie wyższą responsywność, łatwość konserwacji i skalowalność niż zapewnia obecne funkcje serverless.
* Przetwarzanie zdarzeń jest skalowalne poprzez uruchamianie dodatkowych instancji usług do przetwarzania zdarzeń w kolejce.
* Przetwarzanie w ramach usług jest skalowalne poprzez uruchamianie dodatkowych instancji danej usługi w celu zaspokojenia zapotrzebowania na wykonywane przez nią działania.

### *Negatywy*
* Może wystąpić konieczność zdobycia przez zespoły lub osoby nowych umiejętności lub opanowania nowych technologii (takich jak zarządzanie kolejkami zdarzeń).
* Zarządzanie zdarzeniami (takimi jak kolejki) dodatkowo komplikuje proces programowania i wdrażania.
* Testy integracyjne i DevOps będą musiały zostać ponownie zweryfikowane.

