#include <string>
#include <fstream>
#include <gtest/gtest.h>

//
// Ten kod pokazuje, jak wczytać cały plik tekstowy
// do obiektu typu std::string.
//

class ReadFileIntoString : public testing::Test {
protected:

  // Ta metoda jest wykonywana przed rozpoczęciem testu.
  void SetUp() override {
    // Tworzenie pliku, który zostanie wczytany
    initial_content_ = std::string{"Witaj, świecie!"};
    auto out = std::ofstream{"file.txt"};
    out.write(initial_content_.data(), initial_content_.size());
  }

  std::string initial_content_{};
};

TEST_F(ReadFileIntoString, CheckFileSize) {
  auto in = std::ifstream{"file.txt", std::ios::binary | std::ios::ate};
  ASSERT_TRUE(in);

  const auto size = static_cast<size_t>(in.tellg());
  auto content = std::string(size, '\0');
  in.seekg(0);
  in.read(&content[0], size);
  // Teraz content zawiera cały plik

  ASSERT_EQ(initial_content_, content);
  ASSERT_EQ(static_cast<size_t>(size), initial_content_.size());
}
