#include <gtest/gtest.h>

#include <cassert>
#include <iostream>
#include <thread>

// Ten program powoduje sytuację wyścigu, ponieważ dwa wątki
// używają zmiennej globalnej counter bez synchronizacji

namespace {

int counter = 0;

auto increment_counter(int n) {
  for (int i = 0; i < n; i++) {
    ++counter;
  }
}

} // namespace

TEST(CounterDataRace, IncrementCounter) {
  const auto n_times = 1000000;
  std::thread t1(increment_counter, n_times);
  std::thread t2(increment_counter, n_times);

  t1.join(); // Można też użyć wątku std::jthread
  t2.join();

  // Kod powinien zwrócić 2000000, jednak prawdopodobnie będzie to mniejsza liczba.
  std::cout << counter << '\n';
}
