#include <cassert>
#include <gtest/gtest.h>
#include <set>
#include <string>

//
// Ten kod ilustruje stosowanie semantyki wartości.
// Zbiór dodatków, t, jest przekazywany przez wartość i
// w całości kopiowany oraz hermetyzowany w klasie Bagel.
//

class Bagel {
public:
  Bagel(std::set<std::string> ts) : toppings_(std::move(ts)) {}

private:
  std::set<std::string> toppings_;
};

TEST(ValueSemantics, CreateBagels) {

  auto t = std::set<std::string>{};
  t.insert("sól");
  auto a = Bagel{t};

  // Dodanie pieprzu nie wpływa na ‘a’.
  t.insert("pieprz");

  // Obiekt a będzie z solą.
  // Obiekt b będzie z solą i pieprzem.
  auto b = Bagel{t};

  // Nie wpływa na żaden obiekt typu Bagel.
  t.insert("oregano");
}
