#include "adc_dma.h"

#define GPIOAEN			(1U<<0)
#define ADC1EN			(1U<<8)
#define CR1_SCAN		(1U<<8)
#define CR2_DMA			(1U<<8)
#define CR2_DDS			(1U<<9)
#define CR2_CONT		(1U<<1)
#define CR2_ADCON		(1U<<0)
#define CR2_SWSTART		(1U<<30)

#define DMA2EN				(1U<<22)
#define DMA_SCR_EN  		(1U<<0)
#define DMA_SCR_MINC		(1U<<10)
#define DMA_SCR_PINC		(1U<<9)
#define DMA_SCR_CIRC		(1U<<8)
#define DMA_SCR_TCIE		(1U<<4)
#define DMA_SCR_TEIE		(1U<<2)
#define DMA_SFCR_DMDIS		(1U<<2)


uint16_t adc_raw_data[NUM_OF_CHANNELS];

void adc_dma_init(void)
{
	/************ Konfiguracja GPIO **********/
	/* Włączanie dostępu do zegara dla portu GPIO z pinami ADC */
	RCC->AHB1ENR |= GPIOAEN;

	/* Ustawianie PA0 i PA1 w tryb analogowy */
	GPIOA->MODER |= (1U<<0);
	GPIOA->MODER |= (1U<<1);

	GPIOA->MODER |= (1U<<2);
	GPIOA->MODER |= (1U<<3);

	/************ Konfiguracja ADC **********/
	/* Włączanie dostępu do zegara dla ADC*/
	RCC->APB2ENR |= ADC1EN;

	/* Ustawianie długości sekwencji */
	ADC1->SQR1 |= (1U<<20);
	ADC1->SQR1 &= ~(1U<<21);
	ADC1->SQR1 &= ~(1U<<22);
	ADC1->SQR1 &= ~(1U<<23);

	/* Ustawianie sekwencji */
	ADC1->SQR3 = (0U<<0) | (1U<<5);

	/* Włączanie trybu skanowania */
	ADC1->CR1 = CR1_SCAN;

	/* Wybór trybu DMA */
	ADC1->CR2 |=CR2_CONT |CR2_DMA|CR2_DDS;


	/************ Konfiguracja DMA **********/
	/* Włączanie dostępu do zegara dla DMA*/
	RCC->AHB1ENR |=DMA2EN;


	/* Wyłączanie strumienia DMA */
	DMA2_Stream0->CR &=~DMA_SCR_EN;

	/* Czekanie na wyłączenie strumienia DMA */
	while((DMA2_Stream0->CR & DMA_SCR_EN)){}

	/* Włączanie trybu kołowego */
	DMA2_Stream0->CR |=DMA_SCR_CIRC;

	/* Ustawianie MSIZE, tzn. rozmiaru danych w pamięci, na półsłowo */

	DMA2_Stream0->CR |= (1U<<13);
	DMA2_Stream0->CR &= ~(1U<<14);

	/* Ustawianie PSIZE, tzn. rozmiaru danych układu peryferyjnego, na półsłowo */
	DMA2_Stream0->CR |= (1U<<11);
	DMA2_Stream0->CR &= ~(1U<<12);

	/* Włączanie inkrementacji adresu pamięci */
	DMA2_Stream0->CR |=DMA_SCR_MINC;

	/* Ustawianie adresu układu peryferyjnego */
	DMA2_Stream0->PAR = (uint32_t)(&(ADC1->DR));

	/* Ustawianie adresu pamięci */
	DMA2_Stream0->M0AR = (uint32_t)(&adc_raw_data);

	/* Ustawianie liczby transferów */
	DMA2_Stream0->NDTR = (uint16_t)NUM_OF_CHANNELS;

	/* Włączanie strumienia DMA */
	DMA2_Stream0->CR |= DMA_SCR_EN;

	/************ Konfiguracja ADC **********/
	/* Włączanie ADC*/
	ADC1->CR2 |=CR2_ADCON;

	/* Uruchamianie ADC */
	ADC1->CR2 |=CR2_SWSTART;


}
