#include "adxl345.h"

void adxl_read(uint8_t address, uint8_t * rxdata)
{
      /* Ustawianie operacji odczytu */
      address |= ADXL345_READ_OPERATION;

      /* Włączanie trybu wielobajtowego */
      address |= ADXL345_MULTI_BYTE_ENABLE;

      /* Ustawianie linii CS w stan niski w celu aktywacji urządzenia podrzędnego */
      cs_enable();

      /* Wysyłanie adresu */
      spi1_transmit(&address,1);

      /* Odczytywanie 6 bajtów */
      spi1_receive(rxdata,6);

      /* Ustawianie linii CS w stan wysok w celu dezaktywacji urządzenia podrzędnego */
      cs_disable();
}

void adxl_write (uint8_t address, uint8_t value)
{
  uint8_t data[2];
  /* Włączanie trybu wielobajtowego, umieszczanie adresu w buforze */
  data[0] = address|ADXL345_MULTI_BYTE_ENABLE;
  /* Umieszczanie danych w buforze */
  data[1] = value;
  /* Ustawianie linii CS w stan niski w celu aktywacji urządzenia podrzędnego */
  cs_enable();
  /* Przesyłanie danych i adresu */
  spi1_transmit(data, 2);
  /* Ustawianie linii CS w stan wysok w celu dezaktywacji urządzenia podrzędnego */
  cs_disable();
}

void adxl_init (void)
{
    /* Włączanie pinów GPIO dla SPI */
    spi_gpio_init();

    /* Konfigurowanie SPI */
    spi1_config();

    /* Ustawianie zakresu danych na ±4g */
    adxl_write (ADXL345_REG_DATA_FORMAT, ADXL345_RANGE_4G);

    /* Zerowanie wszystkich bitów */
    adxl_write (ADXL345_REG_POWER_CTL, ADXL345_RESET);

    /* Konfigurowanie bitu pomiaru w rejestrze zasilania */
    adxl_write (ADXL345_REG_POWER_CTL, ADXL345_MEASURE_BIT);
}
