#include "standby_mode.h"
#define PWR_MODE_STANDBY                   (PWR_CR_PDDS)
#define WK_PIN		(1U<<0)


static void set_power_mode(uint32_t pwr_mode);

void wakeup_pin_init(void)
{
	// Włączanie zegara dla GPIOA
	RCC->AHB1ENR |= RCC_AHB1ENR_GPIOAEN;

    // Ustawianie pinu PA0 jako wejścia
	GPIOA->MODER &= ~(1U<<0);
	GPIOA->MODER &= ~(1U<<1);

	// Bez podciągania
	GPIOA->PUPDR &= ~(1U<<0);
	GPIOA->PUPDR &= ~(1U<<1);
}

void standby_wakeup_pin_setup(void)
{

    /* Czekanie na zwolnienie pinu wybudzania */
	while(get_wakeup_pin_state() == 0){}

	/* Wyłączanie pinu wybudzania */
	PWR->CSR &=~(1U<<8);

	/* Zerowanie wszystkich flag wybudzania */
	PWR->CR |=(1U<<2);

	/* Włączanie pinu wybudzania */
	PWR->CSR |=(1U<<8);

	/* Wchodzenie w stan gotowości */
	set_power_mode(PWR_MODE_STANDBY);

	/* Ustawianie bitu SLEEPDEEP w rejestrze sterowania systemem CortexM */
	SCB->SCR |=(1U<<2);

	/* Czekanie na przerwanie */
	__WFI();
}


uint32_t get_wakeup_pin_state(void)
{
	  return ((GPIOA->IDR & WK_PIN) == WK_PIN);
}


static void set_power_mode(uint32_t pwr_mode)
{
 MODIFY_REG(PWR->CR, (PWR_CR_PDDS | PWR_CR_LPDS | PWR_CR_FPDS | PWR_CR_LPLVDS | PWR_CR_MRLVDS), pwr_mode);

}
