#include "dma.h"

#define DMA2EN				(1U<<22)
#define DMA_SCR_EN  		(1U<<0)
#define DMA_SCR_MINC		(1U<<10)
#define DMA_SCR_PINC		(1U<<9)
#define DMA_SCR_TCIE		(1U<<4)
#define DMA_SCR_TEIE		(1U<<2)
#define DMA_SFCR_DMDIS		(1U<<2)

void dma2_mem2mem_config(void)
{
	/* Włączanie dostępu do zegara dla modułu DMA */
	RCC->AHB1ENR |= DMA2EN;

	/* Wyłączanie strumienia DMA */
	DMA2_Stream0->CR = 0;

	/* Czekanie na wyłączenie strumienia DMA */
	while((DMA2_Stream0->CR & DMA_SCR_EN)){}

	/* Konfigurowanie parametrów DMA */

	/* Ustawianie MSIZE, tzn. rozmiaru danych w pamięci, na półsłowo */
	DMA2_Stream0->CR |= (1U<<13);
	DMA2_Stream0->CR &= ~(1U<<14);

	/* Ustawianie PSIZE, tzn. rozmiaru danych układu peryferyjnego, na półsłowo */
	DMA2_Stream0->CR |= (1U<<11);
	DMA2_Stream0->CR &= ~(1U<<12);

	/* Włączanie inkrementacji adresu pamięci */
	DMA2_Stream0->CR |=DMA_SCR_MINC;

	/* Włączanie inkrementacji adresu układu peryferyjnego */
	DMA2_Stream0->CR |=DMA_SCR_PINC;

	/* Wybieranie transferu z pamięci do pamięci */
	DMA2_Stream0->CR &= ~(1U<<6);
	DMA2_Stream0->CR |= (1U<<7);

	/* Włączanie przerwania przy zakończeniu transferu */
	DMA2_Stream0->CR |= DMA_SCR_TCIE;

	/* Włączanie przerwania przy błędzie transferu */
	DMA2_Stream0->CR |= DMA_SCR_TEIE;

	/* Wyłączanie trybu bezpośredniego */
	DMA2_Stream0->FCR |=DMA_SFCR_DMDIS;

	/* Usrtawianie progu FIFO DMA */
	DMA2_Stream0->FCR |=(1U<<0);
	DMA2_Stream0->FCR |=(1U<<1);

	/* Włączanie przerwania DMA w kontrolerze NVIC*/
	NVIC_EnableIRQ(DMA2_Stream0_IRQn);
}



void dma_transfer_start(uint32_t src_buff, uint32_t dest_buff, uint32_t len)
{
	/* Ustawianie adresu układu peryferyjnego */
	DMA2_Stream0->PAR = src_buff;

	/* Ustawianie adresu pamięci */
	DMA2_Stream0->M0AR = dest_buff;

	/* Ustawianie długości transferu */
	DMA2_Stream0->NDTR = len;

	/* Włączanie strumienia DMA */
	DMA2_Stream0->CR |= DMA_SCR_EN;

}







