#include "spi.h"
#define SPI1EN         (1U<<12)
#define GPIOAEN        (1U<<0)
#define SR_TXE         (1U<<1)

#define SR_RXNE        (1U<<0)
#define SR_BSY         (1U<<7)

void spi_gpio_init(void)
{
    /* Włączanie dostępu do zegara dla GPIOA */
    RCC->AHB1ENR |= GPIOAEN;

    /* Ustawianie trybu alternatywnego dla pinów PA5, PA6, PA7 */
    /* PA5 */
    GPIOA->MODER &= ~(1U<<10);
    GPIOA->MODER |= (1U<<11);
    /* PA6 */
    GPIOA->MODER &= ~(1U<<12);
    GPIOA->MODER |= (1U<<13);
    /* PA7 */
    GPIOA->MODER &= ~(1U<<14);
    GPIOA->MODER |= (1U<<15);

    /* Ustawianie PA9 jako pinu wyjściowego */
    GPIOA->MODER |= (1U<<18);
    GPIOA->MODER &= ~(1U<<19);

    /* Konfigurowanie funkcji alternatywnej SPI1 dla pinów PA5, PA6, PA7 */
    /* PA5 */
    GPIOA->AFR[0] |= (1U<<20);
    GPIOA->AFR[0] &= ~(1U<<21);
    GPIOA->AFR[0] |= (1U<<22);
    GPIOA->AFR[0] &= ~(1U<<23);
    /* PA6 */
    GPIOA->AFR[0] |= (1U<<24);
    GPIOA->AFR[0] &= ~(1U<<25);
    GPIOA->AFR[0] |= (1U<<26);
    GPIOA->AFR[0] &= ~(1U<<27);
    /* PA7 */
    GPIOA->AFR[0] |= (1U<<28);
    GPIOA->AFR[0] &= ~(1U<<29);
    GPIOA->AFR[0] |=(1U<<30);
    GPIOA->AFR[0] &= ~(1U<<31);

}

void spi1_config(void)
{
    /*Włączanie dostępu do zegara dla modułu SPI1*/
    RCC->APB2ENR |= SPI1EN;
    /*Ustawianie zegar na fPCLK/4*/
    SPI1->CR1 |=(1U<<3);
    SPI1->CR1 &=~(1U<<4);
    SPI1->CR1 &=~(1U<<5);

    /*Ustawianie CPOL na 1 i CPHA na 1*/
    SPI1->CR1 |=(1U<<0);
    SPI1->CR1 |=(1U<<1);
    /*Włączanie trybu pełnodupleksowego*/
    SPI1->CR1 &=~(1U<<10);
    /*Najpierw transmisja MSB*/
    SPI1->CR1 &= ~(1U<<7);
    /*Ustawianie trybu na nadrzędny*/
    SPI1->CR1 |= (1U<<2);
    /*Ustawianie 8-bitowego trybu danych*/
    SPI1->CR1 &= ~(1U<<11);
    /*Wybór programowego zarządzania urządzeniem
    przez ustawienie SSM=1 i SSI=1*/
    SPI1->CR1 |= (1<<8);
    SPI1->CR1 |= (1<<9);
    /*Włączanie modułu SPI*/
    SPI1->CR1 |= (1<<6);
}

void spi1_transmit(uint8_t *data,uint32_t size)
{
    uint32_t i=0;
    uint8_t temp;
    while(i<size)
    {
        /*Czekanie na ustawienie flagi TXE */
        while(!(SPI1->SR & (SR_TXE))){}
        /*Zapisywanie danych do rejestru danych*/
        SPI1->DR = data[i];
        i++;
    }
    /*Czekanie na ustawienie flagi TXE*/
    while(!(SPI1->SR & (SR_TXE))){}
    /*Czekanie na wyzerowanie flagi BUSY*/
    while((SPI1->SR & (SR_BSY))){}

    /*Zerowanie flagi OVR*/
    temp = SPI1->DR;
    temp = SPI1->SR;
}

void spi1_receive(uint8_t *data, uint32_t size)
{
    while(size)
    {
        /* Wysyłanie pustych danych */
        SPI1->DR = 0;
        /* Czekanie na ustawienie flagi RXNE */
        while(!(SPI1->SR & (SR_RXNE))){}
        /* Odczytywanie danych z rejestru */
        *data++ = (SPI1->DR);
        size--;
    }
}

/* Ustawienie stanu niskiego w celu aktywacji */
void cs_enable(void)
{
    GPIOA->ODR &= ~(1U<<9);
}

/* Ustawienie stanu wysokiego w celu dezaktywacji */
void cs_disable(void)
{
    GPIOA->ODR |= (1U<<9);
}
