
// 0: Dołączenie standardowego pliku nagłówkowego z typami całkowitoliczbowymi
#include <stdint.h>

// 1: Definicja struktury GPIO_TypeDef
typedef struct
{
  volatile uint32_t MODER;    /*przesunięcie: 0x00      */
  volatile uint32_t OTYPER;   /*przesunięcie: 0x04      */
  volatile uint32_t OSPEEDR;  /*przesunięcie: 0x08      */
  volatile uint32_t PUPDR;    /*przesunięcie: 0x0C      */
  volatile uint32_t IDR;      /*przesunięcie: 0x10      */
  volatile uint32_t ODR;      /*przesunięcie: 0x14      */
  volatile uint32_t BSRR;     /*przesunięcie: 0x18      */
  volatile uint32_t LCKR;     /*przesunięcie: 0x1C      */
  volatile uint32_t AFRL;     /*przesunięcie: 0x20	 */
  volatile uint32_t AFRH;     /*przesunięcie: 0x24 	 */

} GPIO_TypeDef;

// 2: Definicja struktury RCC_TypeDef
typedef struct
{
  volatile uint32_t DUMMY[12];
  volatile uint32_t AHB1ENR;       /*przesunięcie: 0x30*/

} RCC_TypeDef;


// 3: Definicje adresów bazowych
#define 	RCC_BASE	 0x40023800
#define 	GPIOA_BASE   0x40020000

// 4: Definicje wskaźników do układów peryferyjnych
#define RCC		    ((RCC_TypeDef*) RCC_BASE)
#define GPIOA		((GPIO_TypeDef*)GPIOA_BASE)

//5: Maska bitowa do włączania GPIOA (bit 0)
#define GPIOAEN       (1U<<0)
//6: Maska bitowa dla pinu 5. GPIOA
#define PIN5          (1U<<5)
//7: Alias dla pinu 5. reprezentujący pin LED
#define LED_PIN       PIN5

//  8: Początek funkcji main
int main(void)
{
    //  9: Włączenie dostępu do zegara dla GPIOA
	 RCC->AHB1ENR |=  GPIOAEN;

	 GPIOA->MODER |= (1U<<10);  //  10: Ustawienie bitu 10. na 1
	 GPIOA->MODER &= ~(1U<<11); //  11: Ustawienie bitu 11. na 0

    //  21: Początek nieskończonej pętli
    while(1)
    {
    	//  12: Ustawienie PA5(LED_PIN) w stan wysoki
		GPIOA->ODR^= LED_PIN;

        // 13: Proste opóźnienie
		for(int i=0;i<100000;i++){}

    }

}
