#include <stdio.h>
#include "uart.h"
#include "gpio.h"
#include "iwdg.h"
#include "gpio_exti.h"

uint8_t g_btn_press;
static void check_reset_source(void);

int main(void)
{
    /* Inicjalizacja UART */
    uart_init();

    /* Inicjalizacja diody LED */
    led_init();

    /* Inicjalizacja przerwania zewnętrznego */
    pc13_exti_init();

    /* Sprawdzenie źródła resetu */
    check_reset_source();

    /* Inicjalizacja IWDG */
    iwdg_init();
    while(1)
    {
        if( g_btn_press != 1)
         {
             /* Przeładowanie licznika watchdoga wartością domyślną */
             IWDG->KR = IWDG_KEY_RELOAD;
             led_toggle();
             for(int i = 0; i < 90000; i++){}
         }
    }
}

static void check_reset_source(void)
{
if ((RCC->CSR & RCC_CSR_IWDGRSTF) == (RCC_CSR_IWDGRSTF))
      {
          /* Zerowanie flagi resetu IWDG */
          RCC->CSR = RCC_CSR_RMVF;

          /* Włączanie diody LED */
          led_on();
          printf("RESET spowodowany przez IWDG.....\n\r");

          while( g_btn_press != 1)
          {
          }

          g_btn_press =  0;
      }
}

static void exti_callback(void)
{
    g_btn_press = 1;
}

void EXTI15_10_IRQHandler(void) {
    if((EXTI->PR & LINE13)!=0)
    {
        /* Zerowanie flagi PR */
        EXTI->PR |=LINE13;
        // Tu można coś zrobić...
        exti_callback();
    }
}
