package com.sillars.imagescroll;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.crashlytics.android.Crashlytics;
import com.crittercism.app.Crittercism;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.newrelic.agent.android.NewRelic;
import com.sillars.imagescroll.MyScrollView.OnScrollStoppedListener;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

import java.io.InputStream;
import java.util.ArrayList;

import io.fabric.sdk.android.Fabric;

// Zbieranie danych analitycznych


public class MyActivity extends Activity {

    public int counter =0;
    RelativeLayout rl1;
    RelativeLayout rl2;
    MyScrollView sv;
    TextView hw;
    float swiptedTo;

    ImageView[] imageViews;
    // Początkowa wysokość przewijanego widoku, wykorzystywana w dalszej części kodu
    int InitialScrollViewHeight=30;
    int ScrollViewHeight=InitialScrollViewHeight;
    int imageheight = 500;
    int totalimagecount = 0;
    int ImagestoAdd = 10;
    Long responsetime;
    Long imagetime;
    Long RTT;
    Double AvgRTT;
    public static ArrayList<Integer> RTTtimes=  new ArrayList<Integer>();
    Tracker t;


    // Deklaracje sieciowe
    ConnectivityManager cm;
    NetworkInfo activeNet;
    boolean isWiFi;
    String networkConnection;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Fabric.with(this, new Crashlytics());
        setContentView(R.layout.activity_my);
        rl1 = (RelativeLayout) findViewById(R.id.rl);
        hw = (TextView) findViewById(R.id.HelloWorld);
        sv=new MyScrollView(MyActivity.this, null);
        rl2 = new RelativeLayout(MyActivity.this);
        imageViews=new ImageView[100];
        sv.addView(rl2);
        rl1.addView(sv);


        // Crittercism
        Crittercism.initialize(getApplicationContext(), "54fffdeeb59ef2d535335cd6");
        // NewRelic
        NewRelic.withApplicationToken(
                "AA9955a73e8163582b0f6040ed5cc0c39f4d798d11"
        ).start(this.getApplication());

        // Google Analytics
        final GoogleAnalytics analytics = GoogleAnalytics.getInstance(this);
        // Utworzenie trakera
        //final Tracker t;
        t = analytics.newTracker(R.xml.app_tracker);
        // Włączenie reklam
        t.enableAdvertisingIdCollection(true);
        t.enableExceptionReporting(true);
        t.setScreenName("Początek ekranu");
        t.send(new HitBuilders.ScreenViewBuilder().build());

        final Button dispatchButton = (Button) findViewById(R.id.timingDispatch);
        dispatchButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Ręczne uruchomienie wysyłania danych (niepotrzebne, jeżeli traker ma zdefiniowany interwał wysyłania)
                analytics.dispatchLocalHits();
            }
        });




        // Odczyt wysokości ekranu
        Display display = getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        final int screenHeight = size.y;
        // Jeżeli trzeba, można odczytać również szerokość

        // Dodanie obrazów
        totalimagecount = Imagelooper(ImagestoAdd, totalimagecount, rl2);
        // Wysokość widoku jest powiększana o liczbę dodanych obrazów przemnożoną przez wysokość obrazu
        // ScrollViewHeight = ScrollViewHeight +ImagestoAdd*imageheight;


        sv.setOnTouchListener(new View.OnTouchListener() {


            @Override
            public boolean onTouch(View v, MotionEvent event) {
                // Automatycznie utworzony szablon metody

                // Wywołanie klasy w celu sprawdzenia, gdzie został zatrzymany widok
                if (event.getAction() == MotionEvent.ACTION_MOVE) {

                    sv.startScrollerTask();
                }

                return false;
            }});

        sv.setOnScrollStoppedListener(new OnScrollStoppedListener() {

            public void onScrollStopped() {
                // Odczytanie położenia po zatrzymaniu przewijania
                // Metoda getScrollY() zwraca pozycję u góry ekranu,  ale potrzebna jest dolna pozycja
                sv.getScrollY();
                int bottomofscreen = sv.getScrollY() + screenHeight + InitialScrollViewHeight;
                // Ile jest jeszcze miejsca poniżej dolnej krawędzi ? Ile obrazów?
                int scrollBelowtheFold = ScrollViewHeight - bottomofscreen;
                // Liczba obrazów poniżej dolnej krawędzi
                int ImagesBelowtheFold = Math.round(scrollBelowtheFold / imageheight);

                //Log.i("przewijanie zatrzymane", "zatrzymane");
                Log.i("piksele poniżej kr.", scrollBelowtheFold + " liczba obrazów: " + ImagesBelowtheFold);


                // OK, teraz pora na algorytm pobierania kolejnych obrazów
                AvgRTT = RTTAverage();
                Log.i("średnie opóźnienie", AvgRTT.toString());
                // Jeżeli jest "normalne" opóźnienie
                hw.setText("Opóźnienie: " + AvgRTT.toString());

                Log.i("piksele poniżej kr.", scrollBelowtheFold + " liczba obrazów: " + ImagesBelowtheFold);
                if (AvgRTT < 500) {
                    // Opóźnienie poniżej 1 s
                    // Rozpoczęcie pobierania, jeżeli liczba pozostałych obrazów jest równa 1
                    // Pobranie domyślnych dodawanych obrazów
                    if (ImagesBelowtheFold < 2) {
                        totalimagecount = Imagelooper(ImagestoAdd, totalimagecount, rl2);


                    }

                }
                // Średnie opóźnienie
                else if (AvgRTT < 1500) {
                    // Odłożenie pobierania na później
                    if (ImagesBelowtheFold < 5) {
                        // Można teraz pobierać więcej obrazów, ale nie robimy tego
                        totalimagecount = Imagelooper(ImagestoAdd, totalimagecount, rl2);

                    }

                } else {
                    // Opóźnienie przekracza 1,5 s
                    // Wcześniejsze rozpoczęcie pobierania większej liczby obrazów (2x)
                    if (ImagesBelowtheFold < 5) {
                        totalimagecount = Imagelooper(ImagestoAdd * 2, totalimagecount, rl2);

                    }

                }
                // Odczytanie informacji o połączeniu
                cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
                activeNet = cm.getActiveNetworkInfo();
                isWiFi = activeNet.getType() == ConnectivityManager.TYPE_WIFI;
                if (isWiFi == true){
                    networkConnection = "Wi-Fi";
                }
                else { // Sieć komórkowa
                    TelephonyManager telMan = (TelephonyManager) getSystemService(Context.TELEPHONY_SERVICE);
                    int networkType = telMan.getNetworkType();
                    switch (networkType)
                    {
                        case 7:
                            networkConnection="1xRTT";
                            break;
                        case 4:
                            networkConnection="CDMA";
                            break;
                        case 2:
                            networkConnection="EDGE";
                            break;
                        case 14:
                            networkConnection="eHRPD";
                            break;
                        case 5:
                            networkConnection="EVDO rev. 0";
                            break;
                        case 6:
                            networkConnection="EVDO rev. A";
                            break;
                        case 12:
                            networkConnection="EVDO rev. B";
                            break;
                        case 1:
                            networkConnection="GPRS";
                            break;
                        case 8:
                            networkConnection="HSDPA";
                            break;
                        case 10:
                            networkConnection="HSPA";
                            break;
                        case 15:
                            networkConnection="HSPA+";
                            break;
                        case 9:
                            networkConnection="HSUPA";
                            break;
                        case 11:
                            networkConnection="iDen";
                            break;
                        case 13:
                            networkConnection="LTE";
                            break;
                        case 3:
                            networkConnection="UMTS";
                            break;
                        case 0:
                            networkConnection="Nieznana sieć";
                            break;
                    }
                }
                Log.i("typ sieci", networkConnection);
                hw.append("/n" + networkConnection);
                // Metryki wyświetlane tylko wtedy, gdy poniżej dolnej krawędzi są 2 obrazy
                if (ImagesBelowtheFold < 2) {
                    // Prowizoryczny kod, który nie jest wykonywany w przypadku dużych opóźnień,
                    // gdy ImagesBelowtheFold <4 i ładowane są nowe obrazy. Ale to przecież jest przykładowa aplikacja.
                    // Trzeba wyświetlić 10 kolejnych obrazów, więc należy zmienić nazwę ekranu
                    t.setScreenName(totalimagecount + " obrazów");
                    t.send(new HitBuilders.ScreenViewBuilder()
                            .build());
                    Crittercism.leaveBreadcrumb(totalimagecount + " obrazów");
                    t.send(new HitBuilders.TimingBuilder()
                            .setCategory("RTT").setValue(AvgRTT.longValue())
                            .setVariable("ImageRTT").setLabel("RTT").build());

                    t.send(new HitBuilders.EventBuilder()
                            .setCategory("RTT Event")
                            .setValue(AvgRTT.longValue())
                            .setAction("ImageRTT").setLabel(networkConnection).build());
                    Crittercism.beginTransaction(networkConnection);
                    Crittercism.setTransactionValue(networkConnection, AvgRTT.intValue());
                    Crittercism.endTransaction(networkConnection);


                }

            }
        });

    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Utworzenie menu i dodanie elementów do paska akcji jeżeli jest widoczny
        getMenuInflater().inflate(R.menu.my, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Obsługa kliknięć paska akcji. Kliknięcia przycisków Start i Wstecz
        // są obsługiwane automatycznie jeżeli w pliku AndroidManifest.xml
        // jest wskazany nadrzędny widok aktywności.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
    public int Imagelooper(int numberofaddedimages, int TotalImageCount, RelativeLayout rl){


        for(int i=0;i<numberofaddedimages;i++)
        {
            // Do zmiennej TotalImageCount jest dodawana wartość numberofaddedimages
            // Aby indeks był poprawny do TotalImageCount trzeba dodać 1
            TotalImageCount = 1+TotalImageCount;
            // Na potrzeby analizy trzeba śledzić awarie. Gdy zostanie osiągnięta wartość 100,
            // aplikacja ulegnie awarii.
            if(TotalImageCount ==99){
              //  TotalImageCount=0;
            }
            imageViews[TotalImageCount]=new ImageView(this);

            //    b[i]=new ImageView(this);
            RelativeLayout.LayoutParams params=new RelativeLayout.LayoutParams(
                    (int) ActionBar.LayoutParams.MATCH_PARENT,(int) ActionBar.LayoutParams.MATCH_PARENT);

            params.topMargin=ScrollViewHeight;
            //params.leftMargin=50;

            //  b[i].setText("Button "+i);
            //           counter =i;
            rl2.addView(imageViews[TotalImageCount]);
            Log.i("umieszczenie widoku", "widok nr: "+ TotalImageCount);
            imageViews[TotalImageCount].setLayoutParams(params);
            new ImageDownloader().execute(TotalImageCount);
            ScrollViewHeight = ScrollViewHeight+imageheight;


        }



        return TotalImageCount;

    }



    public  Double RTTAverage() {
        // Wartość opóźnienia jest tylu Long
        // Dodanie opóźnienia do tabeli
        // RTTtimes.add(RTT);
        // Średnia z 5 wartości
        int arraylength = RTTtimes.size();

        int count =5;
        int sum = 0;
        // Jeżeli w tablicy jest mniej niż 5 wartości, nie obliczamy średniej
        // Zwracana jest wartość null i wykorzystywana wartość domyślna

        if (arraylength>=count){

            for (int i=0; i< count; i++) {
                if (RTTtimes.get(arraylength -1 -i) != null){
                    sum = sum + RTTtimes.get(arraylength -1 -i);
                }
            }
        }

        double average = sum/count;

        return average;

    }




    private class ImageDownloader extends AsyncTask<Integer, Void,Bitmap> {


        @Override
        protected Bitmap doInBackground(Integer... param) {
            // Automatycznie utworzony szablon metody

            return downloadBitmap(param[0]);
        }



        @Override
        protected void onPreExecute() {

        }

        @Override
        protected void onPostExecute(Bitmap result) {


            imageViews[counter].setImageBitmap(result);

        }

        private Bitmap downloadBitmap(Integer j) {
            // Pobranie adresu URL na podstawie wartości licznika

            String url = Images.urls[j];
            counter =j;
            Log.i("pobieranie obrazów", "liczba: "+ j.toString());


            Long start = System.currentTimeMillis();
            // Zainicjowanie domyślnego obiektu klienckiego HTTP
            final DefaultHttpClient client = new DefaultHttpClient();

            // Przygotowanie zapytania HTTP
            final HttpGet getRequest = new HttpGet(url);
            try {

                HttpResponse response = client.execute(getRequest);

                // Sprawdzenie kodu 200 OK oznaczającego pomyślny wynik
                final int statusCode = response.getStatusLine().getStatusCode();
                Long gotresponse = System.currentTimeMillis();
                if (statusCode != HttpStatus.SC_OK) {
                    Log.w("pobieranie obrazów", "Błąd " + statusCode +
                          " podczas pobierania z adresu " + url);
                    return null;

                }

                final HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream inputStream = null;
                    try {
                        // Odczytanie treści ze strumienia
                        inputStream = entity.getContent();

                        // Konwersja danych ze strumienia na format graficzny zrozumiały dla systemu Android
                        final Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                        Long gotimage = System.currentTimeMillis();
                        responsetime  = gotresponse - start;
                        imagetime     = gotimage-start;
                        // Ponieważ dane pochodzą z tego samego serwera, przyjmujemy, że czas odpowiedzi jest równy 2 x RTT
                        RTT = responsetime/2;
                        RTTtimes.add(RTT.intValue());


                        Log.i("pobieranie obrazów", "obraz " + j +" czas odpowiezi (2xRTT): "+ responsetime.toString());
                        return bitmap;
                    } finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        entity.consumeContent();
                    }
                }
            } catch (Exception e) {
                // Tu można wpisać dokładniejszy komunikat o wyjątku IOException
                getRequest.abort();
                Log.e("pobieranie obrazów", "Coś poszło źle podczas" +
                      " pobierania obrazu z adresu " + url + e.toString());
            }

            return null;
        }







    }


}
