package com.sillars.imagescroll;

import android.app.Application;

import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;

import java.util.HashMap;

/**
 * Utworzono 10.03.2015
 */
public class Analytics extends Application {

    // Ten wiersz należy zmienić tak, aby zawierał poprawny identyfikator właściwości
    private static final String PROPERTY_ID = "UA-60495201-1";

    public static int GENERAL_TRACKER = 0;

    public enum TrackerName {
        APP_TRACKER, // Traker wykorzystywany tylko w tej aplikacji
        // GLOBAL_TRACKER,    // Traker wykorzystywany we wszystkich aplikacjach w firmie
        // ECOMMERCE_TRACKER, // Traker wykorzystywany we wszystkich transakcjach elektronicznych w firmie
    }

    HashMap<TrackerName, Tracker> mTrackers = new HashMap<TrackerName, Tracker>();

    public Analytics() {
        super();
    }

    synchronized Tracker getTracker(TrackerName trackerId) {
        if (!mTrackers.containsKey(trackerId)) {

            GoogleAnalytics analytics = GoogleAnalytics.getInstance(this);
            analytics.getLogger().setLogLevel(Logger.LogLevel.VERBOSE);
               Tracker t =  analytics.newTracker(R.xml.app_tracker);
                t.enableAdvertisingIdCollection(true);
            mTrackers.put(trackerId, t);
        }
        return mTrackers.get(trackerId);
    }


}