<?php
/*
Plugin Name: Kanał wiadomości ostatnio dodanych obrazów
Plugin URI: http://przyklad.pl/
Description: Dodanie kanału wiadomości informującego o ostatnio dodanych obrazach
Version: 1.0
Author: Ozh
Author URI: http://wrox.com
*/

// Dodanie struktury odnośników bezpośrednich oraz wyczyszczenie reguł przepisywania adresów podczas aktywacji wtyczki.
register_activation_hook( __FILE__, 'boj_addfeed_activate' );
function boj_addfeed_activate() {
    boj_addfeed_add_feed();
    flush_rewrite_rules();
}

// Wyczyszczenie reguł przepisywania adresów podczas dezaktywacji wtyczki.
register_deactivation_hook( __FILE__, 'boj_addfeed_deactivate' );
function boj_addfeed_deactivate() {
    flush_rewrite_rules();
}

// Rejestracja kanału wiadomości.
add_filter( 'init', 'boj_addfeed_add_feed' );
function boj_addfeed_add_feed() {
    add_feed( 'obrazy', 'boj_addfeed_do_feed' );
}

// Wyświetlenie kanału wiadomości.
function boj_addfeed_do_feed( $in ) {

    // Utworzenie włąsnego zapytania w celu pobrania ostatnio dodanych obrazów.
    query_posts(array( 'post_type' => 'attachment', 'post_status' => 'inherit' ));
    
    header('Content-Type: application/atom+xml');
    echo '<?xml version="1.0" encoding="'.get_option('blog_charset').'"?'.'>';
    ?>

<feed xmlns="http://www.w3.org/2005/Atom">
    <title type="text">Ostatnio dodane obrazy na blogu <?php bloginfo_rss('name'); ?></title>
    <?php
    // Początek pętli.
    while (have_posts()) : the_post();
    ?>
    <entry>
        <title><![CDATA[<?php the_title_rss() ?>]]></title>
        <link href="<?php the_permalink_rss() ?>" />
        <published><?php echo get_post_time('Y-m-d\TH:i:s\Z'); ?></published>
        <content type="html"><![CDATA[<?php the_content() ?>]]></content>
    </entry>
    <?php
    // Koniec pętli.
    endwhile ;
    ?>
</feed>

    <?php
}
?>
