<?php 
/*
Plugin Name: Usuwanie komentarzy zgodnie z harmonogramem
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Usuwa komentarze określone jako spam oraz wymoderowane, które są starsze niż wskazana liczba dni.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

// Utworzenie własnego zaczepu powiązanego z harmonogramem cron.
add_action( 'boj_comment_cron_hook', 'boj_cron_delete_comments' );

function boj_cron_delete_comments() {
	global $wpdb;

	$options = get_option( 'boj_cron_comment_options' );
	$boj_comments = $options['boj_comments'];
	$boj_days_old = ( $options['boj_days_old'] ) ? absint( $options['boj_days_old'] ) : 30;

	// Potwierdzenie włączenia opcji.
	if ( $boj_comments ) {
		
		if ( $boj_comments == "spam" ) {
			$boj_comment_status = 'spam';
		} elseif ( $boj_comments == "moderated" ) {
			$boj_comment_status = '0';
		}
		
		$sql = " DELETE FROM $wpdb->comments 
			WHERE ( comment_approved = '$boj_comment_status' )
			AND DATEDIFF( now(), comment_date ) > %d ";
		
		if ( $boj_comments == "both" ) {
			$sql = " DELETE FROM $wpdb->comments 
				WHERE ( comment_approved = 'spam' OR comment_approved = '0'  )
				AND DATEDIFF( now(), comment_date ) > %d ";
		}
	
		$wpdb->query( $wpdb->prepare( $sql, $boj_days_old ) );

	}

}

add_action( 'admin_init', 'boj_cron_comment_init' );

function boj_cron_comment_init(){

	// Rejestracja opcji za pomocą API Settings.
	register_setting(
		'discussion', 
		'boj_cron_comment_options' 
	);
	
	// Rejestracja pola wyboru za pomocą API Settings.
	add_settings_field(
		'boj_cron_comment_type_field',
		'Wybierz komentarze do usunięcia',
		'boj_cron_comment_type',
		'discussion',
		'default'
	);
	
	// Rejestracja pola tekstowego za pomocą API Settings.
	add_settings_field(
		'boj_cron_days_old_field',
		'Usuń komentarze starsze niż',
		'boj_cron_days_old',
		'discussion',
		'default'
	);

	// Wczytanie wartości opcji.
	$options = get_option( 'boj_cron_comment_options' );
	$boj_comments = $options['boj_comments'];
	
	// Jeżeli opcja jest włączona, ale nie zdefiniowano zadania harmonogramu to teraz trzeba dodać odpowiednie  zadanie.
	if ( $boj_comments && !wp_next_scheduled( 'boj_comment_cron_hook' ) ) {
	
		// Zadanie będzie wykonywane co godzinę.
		wp_schedule_event( time(), 'daily', 'boj_comment_cron_hook' );
		
	// Jeżeli opcja NIE jest włączona i zdefiniowano zadanie, trzeba je usunąć z harmonogramu.
	} elseif ( !$boj_comments && wp_next_scheduled( 'boj_comment_cron_hook' ) ) {
	
		// Pobranie godziny następnego uruchomienia zadania.
		$timestamp = wp_next_scheduled( 'boj_comment_cron_hook' );
		
		// Wyrejestrowanie własnego zaczepu akcji.
		wp_unschedule_event( $timestamp, 'boj_comment_cron_hook' );

	}

}

function boj_cron_comment_type() {

	// Wczytanie z bazy danych opcji 'boj_comments'.
	$options = get_option( 'boj_cron_comment_options' );
	$boj_comments = $options['boj_comments'];

	// Wyświetlenie pola wyboru opcji.
	echo '<select name="boj_cron_comment_options[boj_comments]">';
		echo '<option value="" '. selected( $boj_comments, '', false ) .'>brak</option>';
		echo '<option value="spam" '. selected( $boj_comments, 'spam', false ) .'>określone jako spam</option>';
		echo '<option value="moderated" '. selected( $boj_comments, 'moderated', false ) .'>wymoderowane</option>';
		echo '<option value="both" '. selected( $boj_comments, 'both', false ) .'>określone jako spam i wymoderowane</option>';
	echo '</select>';
	
}

function boj_cron_days_old() {

	// Wczytanie z bazy danych opcji 'boj_days_old'.
	$options = get_option( 'boj_cron_comment_options' );
	$boj_days_old = ( $options['boj_days_old'] ) ? absint( $options['boj_days_old'] ) : 30;
	
	// Wyświetlenie pola tekstowego opcji.
	echo '<input type="text" name="boj_cron_comment_options[boj_days_old]" value="' .esc_attr( $boj_days_old ). '" size="3" /> dni';
	
}
?>
