<?php
// Wczytanie środowiska WordPress.
// Umieść ten plik w katalogu głównym WordPress (tam gdzie znajduje się plik wp-load.php).
require('./wp-load.php');
?>
<pre>
<?php

// Wyłączenie wszystkich metod transportu poza CURL.
function boj_onlycurl_force_curl() {
    add_filter( 'use_fsockopen_transport', '__return_false' );
    add_filter( 'use_fopen_transport', '__return_false' );
    add_filter( 'use_streams_transport', '__return_false' );
    add_filter( 'use_http_extension_transport', '__return_false' );
}

// Dodanie własnych parametrów do żądań CURL.
// Wyświetlenie jedynie nazw katalogów FTP (bez atrybutów, wielkości itd.).
function boj_onlycurl_hack_curl_handle( $handle ) {
    curl_setopt( $handle, CURLOPT_FTPLISTONLY, true );
    return $handle;
}

// Podłączenie żądań CURL do zdefiniowanej wcześniej funkcji.
add_action( 'http_api_curl', 'boj_onlycurl_hack_curl_handle' );

// Wykonanie właściwego zadania.
boj_onlycurl_force_curl();

var_dump( wp_remote_get( 'ftp://ftp.gnu.org' ) );

