<?php
/*
Plugin Name: Przykład API Transients
Plugin URI: http://przyklad.pl/
Description: Przykładowa wtyczka pokazująca działanie API Transients.
Author: WROX
Author URI: http://wrox.com
*/

// Fikcyjna funkcja, która pobiera z internetowego radio tytuł aktualnie odtwarzanej piosenki.
function boj_myplugin_fetch_song_title_from_radio() {
	/*
	W tym miejscu znajdzie się kod pobierający dane ze zdalnej witryny internetowej.
	Więcej informacji na ten temat znajdziesz w rozdziale 10.
	
	W tym przykładzie po prostu zwracana jest losowo wybrana piosenka z kilku zdefiniowanych fikcyjnych utworów.
	*/
	
	$titles = array(
		'I Heart WordPress - by WROX Hackers',
		'Highway to Heaven - by AB/CD',
		'WorpDress Roks - by Miss Spellings',
		'Careful With That Hack, Eugene - by Fink Ployd'
	);
	
	// Get a random song title and return it
	$random = $titles[ mt_rand(0, count($titles) - 1) ];
	return $random;
}

// Pobranie tytułu piosenki z bazy danych i ustawienie jej czasu ważności na trzy minuty.
function boj_myplugin_get_song_title() {
	
	// Pobranie krótkotrwałej wartości.
	$title = get_transient( 'boj_myplugin_song' );
	
	// Jeżeli krótkotrwała wartość nie istnieje lub utraciła ważność, wówczas należy ją odświeżyć.
	if( false === $title ) {
		$title = boj_myplugin_fetch_song_title_from_radio();
		set_transient( 'boj_myplugin_song', $title, 180 );
	}
	
	return $title;
}
