<?php
/*
Plugin Name: Przykład 2 dotyczący API Settings
Plugin URI: http://example.com/
Description:Pełny i praktyczny przykład użycia API Settings. Ten powoduje dodanie pola na stronie ustawień prywatności.
Author: WROX
Author URI: http://wrox.com
*/

// Zarejestrowanie i zdefiniowanie ustawień.
add_action('admin_init', 'boj_myplugin_admin_init');
function boj_myplugin_admin_init(){
	register_setting(
		'privacy', 
		'boj_myplugin_options',
		'boj_myplugin_validate_options' 
	);
	
	add_settings_field(
		'boj_myplugin_text_string',
		'Podaj dowolny tekst',
		'boj_myplugin_setting_input',
		'privacy',
		'default'
	);

}

// Wyświetlenie i wypełnienie pola formularza.
function boj_myplugin_setting_input() {
	// Pobranie z bazy danych wartości opcji 'text_string'.
	$options = get_option( 'boj_myplugin_options' );
	$text_string = $options['text_string'];
	// Wyświetlenie pola.
	echo "<input id='text_string' name='boj_myplugin_options[text_string]' type='text' value='$text_string' />";
}

// Weryfikacja danych wejściowych użytkownika (dozwolone jest podanie jedynie tekstu).
function boj_myplugin_validate_options( $input ) {
	$valid['text_string'] = preg_replace( '/[^a-zA-Z]/', '', $input['text_string'] );
	
	if( $valid['text_string'] != $input['text_string'] ) {
		add_settings_error(
			'boj_myplugin_text_string',
			'boj_myplugin_texterror',
			'Wprowadzono nieprawidłową wartość!',
			'error'
		);		
	}
	
	return $valid;
}

