<?php
/**
 * Plugin Name: Okno komunikatu
 * Plugin URI: http://przyklad.pl
 * Description: Przykład wtyczki umieszczającej dwa przyciski w stopce witryny internetowej. Po kliknięciu dowolnego z nich następuje wyświetlenie okna z komunikatem.
 * Version: 0.1
 * Author: WROX
 * Author URI: http://wrox.com
 */

/* Dodanie funkcji tłumaczenia po wczytaniu zaczepu wtyczki. */
add_action( 'plugins_loaded', 'boj_alert_box_load_translation' );

/**
 * Wczytanie pliku tłumaczenia, jeśli wyświetlana strona nie jest administracyjna.
 *
 * @since 0.1
 */
function boj_alert_box_load_translation() {

	/* Jeżeli to nie jest strona administracyjna to można wczytać tłumaczenie wtyczki. */
	if ( !is_admin() )
		load_plugin_textdomain( 'boj-alert-box', false, 'boj-alert-box/languages' );
}

/* Dodanie funkcji skryptu do zaczepu akcji. */
add_action( 'wp_print_scripts', 'boj_alert_box_load_script' );

/**
 * Wczytanie skryptu i przetłumaczenie ciągów tekstowych.
 *
 * @since 0.1
 */
function boj_alert_box_load_script() {

	/* Jeżeli to strony administracyjne WordPress, to nie ma potrzeby dalszego wykonywania funkcji. */
	if ( is_admin() )
		return;

	/* Pobranie ścieżki dostępu i nazwy pliku skryptu. */
	$script = trailingslashit( plugins_url( 'boj-alert-box' ) ) . 'boj-alert-box-script.js';

	/* Zakolejkowanie skryptu do użycia. */
	wp_enqueue_script( 'boj-alert-box', $script, false, 0.1 );

	/* Przetłumaczenie ciągów tekstowych używanych w skrypcie JavaScript. */
	wp_localize_script( 'boj-alert-box', 'boj_alert_box_L10n', array(
		'boj_box_1' => __( 'Te okna są irytujące!', 'boj-alert-box' ),
		'boj_box_2' => __( 'Te okna naprawdę są irytujące!', 'boj-alert-box' ),
	) );
}

/* Umieszczenie w stopce witryny przycisków powodujących wyświetlenie komunikatu. */
add_action( 'wp_footer', 'boj_alert_box_display_buttons' );

/**
 * Wyświetla dwa przyciski w znaczniku akapitu. Każdy przycisk ma zdefiniowane zdarzenie onClick()
 * powodujące wyświetlenie okna komunikatu JavaScript
 * .
 *
 * @since 0.1
 */
function boj_alert_box_display_buttons() {

	/* Przygotowanie kodu HTML dla pierwszego przycisku. */
	$boj_alert_box_buttons = '<input type="button" onclick="boj_show_alert_box_1()" value="' . esc_attr__( 'Naciśnij mnie!', 'boj-alert-box' ) . '" />';

	/* Przygotowanie kodu HTML dla drugiego przycisku. */
	$boj_alert_box_buttons .= '<input type="button" onclick="boj_show_alert_box_2()" value="' . esc_attr__( 'Teraz naciśnij mnie!', 'boj-alert-box' ) . '" />';

	/* Opakowanie przycisków znacznikiem akapitu. */
	echo '<p>' . $boj_alert_box_buttons . '</p>';
}

?>
