<?php 
/*
Plugin Name: Przykład wtyczki tworzącej widget
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka tworząca widget na platformie WordPress
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

// Użycie zaczepu akcji widgets_init w celu wykonania własnej funkcji.
add_action( 'widgets_init', 'boj_widgetexample_register_widgets' );

 // Rejestracja widgetu.
function boj_widgetexample_register_widgets() {
    register_widget( 'boj_widgetexample_widget_my_info' );
}

//boj_widget_my_info class
class boj_widgetexample_widget_my_info extends WP_Widget {

    // Przetworzenie widgetu.
    function boj_widgetexample_widget_my_info() {
        $widget_ops = array( 
			'classname' => 'boj_widgetexample_widget_class', 
			'description' => 'Wyświetla ulubioną piosenkę i film użytkownika.' 
			); 
        $this->WP_Widget( 'boj_widgetexample_widget_my_info', 'Widget informacyjny', $widget_ops );
    }
 
     // Zbudowanie formularza ustawień widgetu.
    function form($instance) {
        $defaults = array( 'title' => 'Moje informacje', 'movie' => '', 'song' => '' ); 
        $instance = wp_parse_args( (array) $instance, $defaults );
        $title = $instance['title'];
        $movie = $instance['movie'];
        $song = $instance['song'];
        ?>
            <p>Tytuł: <input class="widefat" name="<?php echo $this->get_field_name( 'title' ); ?>"  type="text" value="<?php echo esc_attr( $title ); ?>" /></p>
            <p>Ulubiony film: <input class="widefat" name="<?php echo $this->get_field_name( 'movie' ); ?>"  type="text" value="<?php echo esc_attr( $movie ); ?>" /></p>
            <p>Ulubiona piosenka: <textarea class="widefat" name="<?php echo $this->get_field_name( 'song' ); ?>" / ><?php echo esc_attr( $song ); ?></textarea></p>
        <?php
    }
 
    // Zapis ustawień widgetu.
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['movie'] = strip_tags( $new_instance['movie'] );
        $instance['song'] = strip_tags( $new_instance['song'] );
 
        return $instance;
    }
 
    // Wyświetlenie widgetu.
    function widget($args, $instance) {
        extract($args);
 
        echo $before_widget;
        $title = apply_filters( 'widget_title', $instance['title'] );
        $movie = empty( $instance['movie'] ) ? '&nbsp;' : $instance['movie'];
        $song = empty( $instance['song'] ) ? '&nbsp;' : $instance['song']; 
 
        if ( !empty( $title ) ) { echo $before_title . $title . $after_title; };
        echo '<p>Ulubiony film: ' . $movie . '</p>';
        echo '<p>Ulubiona piosenka: ' . $song . '</p>';
        echo $after_widget;
    }
}
?>
