<?php
/*
Plugin Name: Buforowanie powiązanych ze sobą wpisów bloga
Plugin URI: http://przyklad.pl
Description: Wtyczka używa obiektu buforowania w celu buforowania powiązanych ze sobą wpisów bloga.
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/

/* Dodanie do treści wyświetlanego wpisu bloga innych, powiązanych z nim wpisów. */
add_filter( 'the_content', 'boj_cache_related_posts' );

/* Dołączenie listy powiązanych wpisów bloga na stronie wyświetlającej pojedynczy wpis bloga. */
function boj_cache_related_posts( $content ) {

    /* Jeżeli strona nie wyświetla tylko jedno wpisu bloga, wtedy trzeba zwrócić jej treść. */
    if ( !is_singular( 'post' ) )
        return $content;

    /* Pobranie identyfikatora bieżącego wpisu bloga. */
    $post_id = get_the_ID();

    /* Pobranie buforowanych danych dla określonego wpisu bloga. */
    $cache = wp_cache_get( $post_id, 'boj_related_posts' );

    /* Jeżeli żadne dane nie są buforowane. */
    if ( empty( $cache ) ) {

        /* Pobranie kategorii wpisu bloga. */
        $categories = get_the_category();

        /* Pobranie powiązanych wpisów bloga biorąc pod uwagę kategorię wyświetlanego wpisu bloga. */
        $posts = get_posts(
            array(
                'category' => absint( $categories[0]->term_id ),
                'post__not_in' => array( $post_id ),
                'numberposts' => 5
            )
        );

        /* Jeżeli nie zostaną znalezione żadne wpisy bloga. */
        if ( !empty( $posts ) ) {

            /* Utworzenie nagłówka i rozpoczęcie nieuporządkowanej listy. */
            $cache = '<h3>Powiązane wpisy bloga</h3>';
            $cache .= '<ul>';

            /* Iteracja przez każdy wpis bloga i pobranie odnośnika do strony, na której będzie wyświetlony tylko dany wpis bloga. */
            foreach ( $posts as $post ) {
                $cache .= '<li><a href="' . get_permalink( $post->ID ) . '">' . 
                    get_the_title( $post->ID ) . '</a></li>';
            }

            /* Zamknięcie nieuporządkowanej listy. */
            $cache .= '</ul>';

            /* Buforowanie przez dwanaście godzin listy powiązanych wpisów bloga. */
            wp_cache_set( $post_id, $cache, 'boj_related_posts', 60 * 60 * 12 );
        }
    }

    /* Jeżeli są buforowane dane, wtedy należy je dołączyć do treści wpisu bloga. */
    if ( !empty( $cache ) )
        $content .= $cache;

    /* Zwrócenie treści wpisu bloga. */
    return $content;
}

?>
