<?php
/*
Template Name: Sklep
*/
?>

<?php get_header(); ?>

<div id="container">
    <div id="content" role="main">
    <?php
    $stores = array(
        'lodz' => array(
            'name'    => "Sklep w Łodzi",
            'manager' => 'Robert Nowak',
            'address' => 'ul. Nowa 123, Łódź',
            'phone'   => '555-31337-1337'
        ),
        'gliwice' => array(
            'name'    => "Sklep w Gliwicach",
            'manager' => 'Bartosz Malinowski',
            'address' => 'ul. Malinowa 45, Gliwice',
            'phone'   => '555-666-696969'
        ),
        'gdansk' => array(
            'name'    => "Sklep w Gdańsku",
            'manager' => 'Zuzanna Kowalska',
            'address' => 'ul. Nadbrzeżna 67',
            'phone'   => '4-8-15-16-23-42'
        )
    );
    
    // Pobranie identyfikatora sklepu.
    $store = get_query_var( 'store_id' );
    
    // Jeżeli sklep istnieje, wyświetlamy informacje na jego temat.
    if( array_key_exists( $store, $stores ) ) {
    
        extract( $stores[$store] );
        echo "<p>Sklep: $name</p>";
        echo "<p>Menedżer: $manager</p>";
        echo "<p>Adres: $address</p>";
        echo "<p>Kontakt: $phone</p>";
    
    // Jeżeli sklep nie istnieje, wyświetlamy listę wszystkich sklepów.
    } else {
        
        // Pobranie adresu URL bieżącej strony.
        global $post;
        $page = untrailingslashit( get_permalink( $post->ID ) );
        
        echo '<p>Nasze sklepy:</p>';
        echo '<ul>';
        foreach( $stores as $store => $info ) {
            $name = $info['name'];
            echo "<li><a href='$page/$store/'>$name</a></li>\n";
        }
        echo '</ul>';
    }
    
    ?>
    </div><!-- #content -->
</div><!-- #container -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>

