<?php 
/*
Plugin Name: Wtyczka Pester 
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wysyła wiadomość e-mail, jeśli przez trzy dni nie został opublikowany żaden wpis bloga.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

// Utworzenie własnego zaczepu powiązanego z harmonogramem cron.
add_action( 'boj_pester_cron_hook', 'boj_cron_pester_check' );

function boj_cron_pester_check() {
	global $wpdb;

	// Ustalenie daty ostatnio opublikowanego wpisu bloga.
	$sql = " SELECT post_date FROM $wpdb->posts WHERE post_status = 'publish' AND post_type = 'post' ORDER BY post_date DESC LIMIT 1 ";
	$latest_post_date = $wpdb->get_var( $wpdb->prepare( $sql ) );
	
	if ( strtotime( $latest_post_date ) <= strtotime('-3 day') ) {
		// Wpis bloga jest starszy niż trzy dni.

		// Podanie informacji niezbędnych do wysłania wiadomości e-mail.
		$email_to = 'ty@przyklad.pl';
		$email_subject = 'Przypomnienie';
		$email_msg = 'Co się dzieje z blogiem? Minęły już co najmniej trzy dni odkąd opublikowałeś ostatni wpis bloga.';
		
		// Wysłanie wiadomości e-mail.
		wp_mail( $email_to, $email_subject, $email_msg );

	}

}

add_action( 'admin_init', 'boj_cron_pester_init' );

function boj_cron_pester_init(){

	// Rejestracja opcji za pomocą API Settings.
	register_setting(
		'writing', 
		'boj_cron_pester_options' 
	);
	
	// Rejestracja pola za pomocą API Settings.
	add_settings_field(
		'boj_cron_pester_field',
		'Włączyć przypomnienie o potrzebie utworzenia nowego wpisu bloga?',
		'boj_cron_pester_setting',
		'writing',
		'default'
	);

	// Wczytanie wartości opcji.
	$options = get_option( 'boj_cron_pester_options' );
	$boj_pester = $options['boj_pester'];
	
	// Jeżeli opcja jest włączona, ale nie zdefiniowano zadania harmonogramu to teraz trzeba dodać odpowiednie  zadanie.
	if ( $boj_pester == 'on' && !wp_next_scheduled( 'boj_pester_cron_hook' ) ) {
	
		// Zadanie będzie wykonywane co godzinę.
		wp_schedule_event( time(), 'daily', 'boj_pester_cron_hook' );
		
	// Jeżeli opcja NIE jest włączona i zdefiniowano zadanie, trzeba je usunąć z harmonogramu.
	} elseif ( $boj_pester != 'on' && wp_next_scheduled( 'boj_pester_cron_hook' ) ) {
	
		// Pobranie godziny następnego uruchomienia zadania.
		$timestamp = wp_next_scheduled( 'boj_pester_cron_hook' );
		
		// Wyrejestrowanie własnego zaczepu akcji.
		wp_unschedule_event( $timestamp, 'boj_pester_cron_hook' );

	}

}

function boj_cron_pester_setting() {

	// Wczytanie z bazy danych opcji 'boj_pester'.
	$options = get_option( 'boj_cron_pester_options' );
	$boj_pester = $options['boj_pester'];

	// Wyświetlenie pola wyboru opcji.
	echo "<input id='boj_pester' name='boj_cron_pester_options[boj_pester]' type='checkbox' ". checked( $boj_pester, 'on', false ). " />";
	
}

?>
