<?php
/*
Plugin Name: Przykład skrótu nr 6
Plugin URI: http://przyklad.pl/
Description: Umożliwia stosowanie skrótów [url] i [b] w komentarzach.
Version: 1.0
Author: Ozh
Author URI: http://wrox.com/
*/

// Rejestracja dla zaczepu 'comment_text' funkcji odpowiedzialnej za przetworzenie komentarza.
add_filter( 'comment_text', 'boj_sc6_comments' );

// Funkcja przetwarzająca treść komentarza.
function boj_sc6_comments( $comment ) {
    
    // Zapisanie zarejestrowanych skrótów:
    global $shortcode_tags;
    $original = $shortcode_tags;
    
    // Wyrejestrowanie wszystkich skrótów:
    remove_all_shortcodes();
    
    // Zarejestrowanie nowych skrótów:
    add_shortcode( 'url', 'boj_sc6_comments_url' );
    add_shortcode( 'b', 'boj_sc6_comments_bold' );
    add_shortcode( 'strong', 'boj_sc6_comments_bold' );
    
    // Usunięcie wszystkich znaczników HTML z komentarza:
    $comment = wp_strip_all_tags( $comment );
    
    // Przetworzenie treści komentarza z uwzględnieniem skrótów:
    $comment = do_shortcode( $comment );
    
    // Wyrejestrowanie skrótów komentarza, przywrócenie zapisanych skrótów.
    $shortcode_tags = $original;
    
    // Zwrócenie komentarza:
    return $comment;
}

// Skrót [b] lub [strong] powoduje wywołanie funkcji zastępującej skrót znacznikiem <strong>.
function boj_sc6_comments_bold( $attr, $text ) {
    return '<strong>' .do_shortcode( $text ). '</strong>';
}

// Skrót [url] powoduje wywołanie funkcji zastępującej skrót znacznikiem <a>.
function boj_sc6_comments_url( $attr, $text ) {
    $text = esc_url( $text );
    return "<a href=\"$text\">$text</a>";
}
?>
